<?php
class CartController extends BaseController {
    public function add() {
        session_start();
        $payload = $_POST;
        $product_id = intval($payload['product_id'] ?? 0);
        $variant_id = intval($payload['variant_id'] ?? 0);
        $qty = max(1, intval($payload['qty'] ?? 1));
        if (!$product_id) $this->json(['error'=>'invalid product']);

        $key = $product_id . '_' . $variant_id;
        $cart = $_SESSION['cart'] ?? [];
        if (!isset($cart[$key])) {
            $cart[$key] = ['product_id'=>$product_id, 'variant_id'=>$variant_id, 'qty'=>$qty];
        } else {
            $cart[$key]['qty'] += $qty;
        }
        $_SESSION['cart'] = $cart;
        $count = array_sum(array_column($cart,'qty'));
        $this->json(['status'=>'ok','cart_count'=>$count]);
    }

    public function view() {
        session_start();
        $cart = $_SESSION['cart'] ?? [];
        $productModel = new Product();
        $items = [];
        foreach ($cart as $c) {
            $p = $productModel->findWithVariant($c['product_id'], $c['variant_id']);
            if (!$p) continue;
            $p['qty'] = $c['qty'];
            $items[] = $p;
        }
        $this->view('cart', ['items'=>$items]);
    }

    public function checkout() {
        session_start();
        $cart = $_SESSION['cart'] ?? [];
        if (empty($cart)) $this->json(['error'=>'Cart is empty']);
        $data = [
            'name'=>$_POST['name'] ?? '',
            'email'=>$_POST['email'] ?? '',
            'phone'=>$_POST['phone'] ?? '',
            'address'=>$_POST['address'] ?? '',
        ];
        $orderModel = new Order();
        $id = $orderModel->createOrder($data, $cart);
        unset($_SESSION['cart']);
        $this->json(['status'=>'ok','order_id'=>$id]);
    }
}
