<?php
class App {
    public function run() {
        $uri = $_SERVER['REQUEST_URI'];
        $script = $_SERVER['SCRIPT_NAME'];
        // normalize for subfolder if needed
        $base = rtrim(dirname($script), '/\\');
        if ($base !== '' && strpos($uri, $base) === 0) $uri = substr($uri, strlen($base));
        $uri = trim(parse_url($uri, PHP_URL_PATH), '/');
        $parts = $uri === '' ? [] : explode('/', $uri);
        $controller = !empty($parts[0]) ? ucfirst($parts[0]) . 'Controller' : 'HomeController';
        $method = $parts[1] ?? 'index';
        $params = array_slice($parts, 2);

        if (!class_exists($controller)) $controller = 'HomeController';
        $ctrl = new $controller();
        if (!method_exists($ctrl, $method)) $method = 'index';
        call_user_func_array([$ctrl, $method], $params);
    }
}
