<?php
require_once __DIR__ . '/Config.php';
class Database {
    private static $instance = null;
    private $pdo;

    private function __construct() {
        $dsn = 'mysql:host=' . Config::$db['host'] . ';dbname=' . Config::$db['name'] . ';charset=utf8mb4';
        $this->pdo = new PDO($dsn, Config::$db['user'], Config::$db['pass'], [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]);
    }

    public static function getInstance() {
        if (self::$instance === null) self::$instance = new Database();
        return self::$instance->pdo;
    }
}
