<?php
class Product extends Model {
    public function all($limit = 100) {
        $stmt = $this->db->prepare('SELECT * FROM products ORDER BY id DESC LIMIT ?');
        $stmt->execute([$limit]);
        return $stmt->fetchAll();
    }

    public function allWithVariants() {
        $products = $this->all(1000);
        foreach ($products as &$p) {
            $stmt = $this->db->prepare('SELECT * FROM variants WHERE product_id = ?');
            $stmt->execute([$p['id']]);
            $p['variants'] = $stmt->fetchAll();
        }
        return $products;
    }

    public function find($id) {
        $stmt = $this->db->prepare('SELECT * FROM products WHERE id = ? LIMIT 1');
        $stmt->execute([$id]);
        $p = $stmt->fetch();
        if ($p) {
            $stmt = $this->db->prepare('SELECT * FROM variants WHERE product_id = ?');
            $stmt->execute([$id]);
            $p['variants'] = $stmt->fetchAll();
        }
        return $p;
    }

    public function findWithVariant($id, $variant_id=0) {
        $p = $this->find($id);
        if (!$p) return null;
        $selected = null;
        if ($variant_id) {
            foreach ($p['variants'] as $v) if ($v['id']==$variant_id) { $selected = $v; break; }
        }
        $p['selected_variant'] = $selected;
        return $p;
    }

    public function save($data, $files) {
        if (!empty($data['id'])) {
            $stmt = $this->db->prepare('UPDATE products SET name=?, description=?, price=?, stock=? WHERE id=?');
            $stmt->execute([$data['name'],$data['description'],$data['price'],$data['stock'],$data['id']]);
            $pid = $data['id'];
        } else {
            $image = '';
            if (!empty($files['image']['tmp_name'])) {
                $fn = time().'_'.basename($files['image']['name']);
                move_uploaded_file($files['image']['tmp_name'], __DIR__.'/../../public/uploads/'.$fn);
                $image = '/uploads/'.$fn;
            }
            $stmt = $this->db->prepare('INSERT INTO products (name, description, price, image, stock, created_at) VALUES (?,?,?,?,?,NOW())');
            $stmt->execute([$data['name'],$data['description'],$data['price'],$image,$data['stock'] ?? 0]);
            $pid = $this->db->lastInsertId();
        }
        // variants handling
        if (!empty($data['variant_name']) && is_array($data['variant_name'])) {
            $this->db->prepare('DELETE FROM variants WHERE product_id = ?')->execute([$pid]);
            $names = $data['variant_name'];
            $prices = $data['variant_price'];
            foreach ($names as $i => $n) {
                $pr = $prices[$i] ?? 0;
                $this->db->prepare('INSERT INTO variants (product_id, name, price) VALUES (?,?,?)')->execute([$pid, $n, $pr]);
            }
        }
        return $pid;
    }
}
