<h3>Your Cart</h3>
<?php if(empty($items)): ?>
  <p>Cart is empty.</p>
<?php else: ?>
  <table class="table">
    <thead><tr><th>Product</th><th>Variant</th><th>Price</th><th>Qty</th><th>Subtotal</th></tr></thead>
    <tbody>
    <?php $total=0; foreach($items as $it): 
      $price = $it['selected_variant']['price'] ?? $it['price'] ?? 0;
      $subtotal = $price * $it['qty'];
      $total += $subtotal;
    ?>
      <tr>
        <td><?php echo htmlspecialchars($it['name']);?></td>
        <td><?php echo htmlspecialchars($it['selected_variant']['name'] ?? ''); ?></td>
        <td>₹ <?php echo number_format($price,2);?></td>
        <td><?php echo intval($it['qty']);?></td>
        <td>₹ <?php echo number_format($subtotal,2);?></td>
      </tr>
    <?php endforeach;?>
    </tbody>
  </table>
  <h4>Total: ₹ <?php echo number_format($total,2);?></h4>

  <h5 class="mt-4">Checkout</h5>
  <form id="checkout-form">
    <div class="mb-2"><input name="name" class="form-control" placeholder="Full name" required></div>
    <div class="mb-2"><input name="email" class="form-control" placeholder="Email" required></div>
    <div class="mb-2"><input name="phone" class="form-control" placeholder="Phone" required></div>
    <div class="mb-2"><textarea name="address" class="form-control" placeholder="Address" required></textarea></div>
    <button class="btn btn-primary">Place Order</button>
  </form>
  <div id="checkout-msg"></div>

  <script>
  $('#checkout-form').on('submit', function(e){
    e.preventDefault();
    $.post('/cart/checkout', $(this).serialize(), function(res){
      if(res.status=='ok'){ $('#checkout-msg').html('<div class="alert alert-success">Order placed. ID: '+res.order_id+'</div>'); $('#cart-count').text('0'); }
      else $('#checkout-msg').html('<div class="alert alert-danger">Error: '+(res.error||'')+'</div>');
    }, 'json');
  });
  </script>
<?php endif; ?>
