<div class="row g-3">
<?php foreach($products as $p): ?>
  <div class="col-12 col-sm-6 col-md-4">
    <div class="card h-100 shadow-sm">
      <?php if(!empty($p['image'])): ?>
        <img src="<?php echo htmlspecialchars($p['image']); ?>" class="card-img-top" style="height:200px;object-fit:cover;">
      <?php endif;?>
      <div class="card-body d-flex flex-column">
        <h5 class="card-title"><?php echo htmlspecialchars($p['name']); ?></h5>
        <p class="card-text small text-muted"><?php echo htmlspecialchars(substr($p['description'],0,120)); ?></p>
        <div class="mt-auto">
          <div class="d-flex justify-content-between align-items-center mb-2">
            <strong>₹ <?php echo number_format($p['price'],2); ?></strong>
            <span class="text-muted small">Stock: <?php echo intval($p['stock'] ?? 0); ?></span>
          </div>
          <a href="/home/product/<?php echo $p['id'];?>" class="btn btn-primary w-100">View</a>
        </div>
      </div>
    </div>
  </div>
<?php endforeach;?>
</div>
